//main character class
public abstract class Character
{
    public abstract string Name { get; }
    public abstract IAttack StandardAttack { get; }
    public abstract int MaxHealth { get; }
    public  int CurrentHealth { get; protected set; }
    public bool IsAlive => CurrentHealth > 0;

    // set current health to max health
    protected Character()
    {
        CurrentHealth = MaxHealth;
    }
// method for damage intake
    public void TakeDamage(int damage)
    {
        CurrentHealth -= damage;
        if (CurrentHealth <= 0)
        {
            CurrentHealth = 0;
        }
    }
    // method for healing
    public void Heal(int healing)
    {
        CurrentHealth += healing;
        if (CurrentHealth > MaxHealth)
        {
            CurrentHealth = MaxHealth;
        }
    }
}

//simple skeleton 
public class Skeleton: Character
{
    public override string Name => "SKELETON";
    public override int MaxHealth => 5;

    public override IAttack StandardAttack=> new BoneCrunch();

    public Skeleton()
    {
        CurrentHealth = MaxHealth;
    }
}
// THE UNCODED ONE DUN DUN DUNNNNNN
public class UncodedOne: Character
{
    public override string Name => "THE UNCODED ONE";
    public override int MaxHealth => 15;
    public override IAttack StandardAttack => new ForgetfulSpell();
    public UncodedOne()
    {
        CurrentHealth = MaxHealth;
    }
}
//True Programmer Class
public class PlayerCharacter: Character
{
    public override string? Name { get; }
    public override IAttack StandardAttack => new Punch();

    public override int MaxHealth => 25;
//set CurrentHealth to MaxHealth for Character
    public PlayerCharacter(string name)
    {
        CurrentHealth = MaxHealth;
        Name = name.ToUpper();
    }

    
}